/* FILE: mbase36.c                              (D. Tottingham  07/28/89)

This is a collection of C functions that manage base 36 numbers for xdetect.
All functions have been written and compiled medium.  The following functions
are included:

b_convert_base10 ()             convert base 36 number into base 10 number
b_incr_base36 ()                increment a base 36 number
b_init_base36 ()                initialize a base 36 number

EXTERNAL FUNCTIONS CALLED:
   none

HISTORY:
   none

*/


/*************************************************************************
                            INCLUDE FILES


*************************************************************************/
#include "mbase36.h"
#include "mconst.h"


/*************************************************************************
                                GLOBALS


*************************************************************************/
char * base36_num[] = {               /* base36 conversion array */
       "0", "1", "2", "3", "4", "5", "6", "7",
       "8", "9", "A", "B", "C", "D", "E", "F",
       "G", "H", "I", "J", "K", "L", "M", "N",
       "O", "P", "Q", "R", "S", "T", "U", "V",
       "W", "X", "Y", "Z"
       };


/*=======================================================================*
 *                         b_convert_base10                              *
 *=======================================================================*/
/* Convert a base 36 number into a base 10 number.                       */

PUBLIC
unsigned int b_convert_base10 (number)
B_BASE36 number;
{
   return (number.high * 36 + number.low);
}

/*=======================================================================*
 *                            b_incr_base36                              *
 *=======================================================================*/
/* Increment a base 36 number.                                           */

PUBLIC
void b_incr_base36 ( number_ptr )
B_BASE36 * number_ptr;
{
   number_ptr->low++;
   if (number_ptr->low == 36) {
      number_ptr->high++;
      number_ptr->low = 0;
   }
}

/*=======================================================================*
 *                           b_init_base36                               *
 *=======================================================================*/
/* Initialize a base 36 number.                                          */

PUBLIC
void b_init_base36 ( number_ptr )
B_BASE36 * number_ptr;
{
   (*number_ptr).high = 0;
   (*number_ptr).low  = -1;
}
